﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Runtime.InteropServices;
using InputDevices;
using System.Drawing;
using System.Windows.Interop;
using TwoCamWPF.Settings;
using TwoCamWPF.Helpers;
using System.Threading;
using System.Diagnostics;
using System.Reflection;

namespace TwoCamWPF
{
    /// <summary>
    /// Логика взаимодействия для MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
       // VideoForm f = new VideoForm();
        Settings.ClassSettings settings = Program.settings;
        public MainWindow()
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Инициализация главной формы"); 
            InitializeComponent();
            settings.OnLoaded += prewpanel.ApplySettings;// ApplySettings;
            settings.OnLocked += prewpanel.SetSettings;
            prewpanel.ApplySettings(settings);
            button4.DataContext = Program.fileWatcher;
            button3.DataContext = Program.fileWatcher;
            this.DataContext = settings.StartSettings;
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

    
        private void gridSplitter1_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (e.ClickCount == 1)
                grid1.ColumnDefinitions[0].Width = new GridLength(0);
        }


        private void button2_Click(object sender, RoutedEventArgs e)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Нажата кнопка открытия настроек");

            using (frmSettings formSettings = new frmSettings(settings))
            {
                formSettings.ShowDialog();
            }

        }

       private void thumb1_DragStarted(object sender, System.Windows.Controls.Primitives.DragStartedEventArgs e)
        {
            thumb1.DataContext = planImg;
        }

        private void thumb1_DragDelta(object sender, System.Windows.Controls.Primitives.DragDeltaEventArgs e)
        {

            (thumb1.DataContext as System.Windows.Controls.Image).Margin =
                new Thickness(
                    (thumb1.DataContext as System.Windows.Controls.Image).Margin.Left + e.HorizontalChange,
                    (thumb1.DataContext as System.Windows.Controls.Image).Margin.Top + e.VerticalChange,
                    (thumb1.DataContext as System.Windows.Controls.Image).Margin.Right - e.HorizontalChange,
                    (thumb1.DataContext as System.Windows.Controls.Image).Margin.Bottom - e.VerticalChange);
            thumb1.Margin = new Thickness(
                thumb1.Margin.Left + e.HorizontalChange,
                thumb1.Margin.Top + e.VerticalChange,
                thumb1.Margin.Right - e.HorizontalChange,
                thumb1.Margin.Bottom - e.VerticalChange);
        
        
        }

        private void thumb1_DragCompleted(object sender, System.Windows.Controls.Primitives.DragCompletedEventArgs e)
        {
        }
        //[DllImport("user32.dll")]
        //static extern int SetParent(int hWndChild, int hWndNewParent);

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            prewpanel.Dispose();

            Program.Close();
        }

        private void Image_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {

        }

        private void ButtonClicked(object sender, RoutedEventArgs e)
        {

        }

        private void button5_Click(object sender, RoutedEventArgs e)
        {
            Process.Start(settings.RecordSettings.SaveFolder);
        }

        private void button4_Click(object sender, RoutedEventArgs e)
        {
            Program.fileWatcher.IsRecording = true;
        }

        private void button3_Click(object sender, RoutedEventArgs e)
        {
            Program.fileWatcher.IsRecording = false;
        }
    }

  
}
